package pt.caf_pbs.schooldiskclient;

import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.Button;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.activity.result.ActivityResult;
import androidx.activity.result.ActivityResultCallback;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.appcompat.app.AppCompatActivity;
import pt.caf_pbs.schooldiskclient.dto.SchoolInfoDTO;
import pt.caf_pbs.schooldiskclient.helper.Utils;
import pt.caf_pbs.schooldiskclient.model.SchoolInfo;
import pt.caf_pbs.schooldiskclient.service.RequestsService;
import pt.caf_pbs.schooldiskclient.ui.InstructorsActivity;
import pt.caf_pbs.schooldiskclient.ui.SettingsActivity;
import pt.caf_pbs.schooldiskclient.ui.SubjectsActivity;

public class MainActivity extends AppCompatActivity {
    private int i = 0;
    private ProgressBar pdRing;
    private TextView textView, hello;
    private ActivityResultLauncher<Intent> someActivityResultLauncher;
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        someActivityResultLauncher = registerForActivityResult(
                new ActivityResultContracts.StartActivityForResult(),
                new ActivityResultCallback<ActivityResult>() {
                    @Override
                    public void onActivityResult(ActivityResult result) {
                        textView.setText("Base url:"+ Utils.getWSAddress(MainActivity.this));
                    }
                });
        pdRing = (ProgressBar) findViewById(R.id.progressBar);
        pdRing.setVisibility(ProgressBar.INVISIBLE);

        Button bt = (Button)findViewById(R.id.instructors);
        bt.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                Intent i = new Intent(MainActivity.this, InstructorsActivity.class);
                someActivityResultLauncher.launch(i);
            }
        });
        Button bt2 = (Button)findViewById(R.id.subjects);
        bt2.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                Intent i = new Intent(MainActivity.this, SubjectsActivity.class);
                i.putExtra(Utils.PICK, false);
                someActivityResultLauncher.launch(i);
            }
        });
        textView = findViewById(R.id.textview);
        hello = findViewById(R.id.hello);
        textView.setText("Base url:"+ Utils.getWSAddress(MainActivity.this));

        getUserDataFromWS();

    }

    private void getUserDataFromWS(){
        new Thread() {
            public void run() {
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        pdRing.setVisibility(ProgressBar.VISIBLE);
                    }
                });


                SchoolInfo schoolInfo = RequestsService.getSchoolInfo(getApplicationContext());
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        if(schoolInfo != null && schoolInfo.getVersion().length() > 0) {
                            hello.setText(schoolInfo.toString());
                        }else{
                            textView.setText("No response from WebServer in  URL:"+ RequestsService.lastUrl);
                        }
                        pdRing.setVisibility(ProgressBar.GONE);
                    }
                });
            }
        }.start();
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        getMenuInflater().inflate(R.menu.optionmenu_main, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        Intent intent;
        switch (item.getItemId()) {
            case R.id.reload:
                getUserDataFromWS();
                return true;
            case R.id.settings:
                Intent i = new Intent(MainActivity.this, SettingsActivity.class);
                someActivityResultLauncher.launch(i);
                return true;
            default:
                return super.onOptionsItemSelected(item);
        }
    }

    @Override
    protected void onPostResume() {
        super.onPostResume();

    }
}
